function searchResults() {
  const resultsSearchBox = document.querySelector('#resultsSearchbox');

  if (resultsSearchBox) {
    const ALGOLIA_ID = '0X4IAR77M1'; // Algolia ID
    const ALGOLIA_KEY = '591d39ef5124b1813557f8e7f123cbd1'; // Algolia API Key

    const searchClient = algoliasearch(ALGOLIA_ID, ALGOLIA_KEY);

    aa('init', {
      appId: ALGOLIA_ID,
      apiKey: ALGOLIA_KEY,
      useCookie: true,
    });

    const hitsContainer = document.querySelector('#resultsHits');
    const statsContainer = document.querySelector('#resultsStats');
    const refinementContainer = document.querySelector(
      '.filter-stats-container'
    );
    const docsLink = document.querySelector('#docsLink');

    const queryParameter = new URLSearchParams(window.location.search).get('q');

    if (queryParameter) {
      docsLink.href =
        'https://docs.starburst.io/searchresults?q=' + queryParameter;
    }

    const searchResults = instantsearch({
      indexName: 'Marketing',
      searchClient,
      searchFunction: function (helper) {
        if (helper.state.query.length < 2) {
          hitsContainer.style.display = 'none';
          statsContainer.style.display = 'none';
          refinementContainer.style.display = 'none';
        } else {
          hitsContainer.style.display = 'block';
          statsContainer.style.display = 'flex';
          refinementContainer.style.display = 'flex';
          helper.search();
        }
      },
    });

    const renderStats = (renderOptions) => {
      const { nbHits } = renderOptions;

      document.querySelector('#resultsStats').innerHTML = `
      <p>Found ${nbHits} results</p>`;
    };

    const customStats = instantsearch.connectors.connectStats(renderStats);

    searchResults.addWidgets([
      instantsearch.widgets.configure({
        attributesToSnippet: ['post_content:30'],
        clickAnalytics: true,
        snippetEllipsisText: '...',
        filters: 'post_status: "publish"',
      }),

      instantsearch.widgets.searchBox({
        container: '#resultsSearchbox',
        showLoadingIndicator: true,
        showReset: true,
        placeholder: 'Search for...',
      }),

      instantsearch.widgets.refinementList({
        container: '#resultsRefinementList',
        attribute: 'post_type',
        sortBy: ['post_title:desc', 'count:desc'],
      }),

      instantsearch.widgets.pagination({
        container: '#pagination',
        showPrevious: false,
        showNext: false,
      }),

      instantsearch.widgets.hits({
        container: '#resultsHits',
        templates: {
          item: (hit, bindEvent) => {
            return (
              `<a ${bindEvent('click', hit, 'Item clicked')} href="` +
              hit.url +
              `"><li>
                  <h6 style="font-weight:500;color: #b835a1;${
                    !hit.resource_type ? 'text-transform: capitalize;' : ''
                  }">${
                hit.resource_type ? hit.resource_type : hit.post_type
              }</h6>
                  <h2 style="font-weight:500;">
                    ${instantsearch.highlight({
                      attribute: 'post_title',
                      hit: hit,
                    })}
                  </h2>
                  ${
                    hit.post_content &&
                    `<p>
                  ${instantsearch.snippet({
                    attribute: 'post_content',
                    hit: hit,
                  })}
                  </p>`
                  }
              </li>
              </a>`
            );
          },
          empty: (results) => {
            refinementContainer.style.display = 'none';
            return `<div id="noResults">
                  <h2>We're sorry!</h2>
                  <p>We couldn't find any results for: "${
                    results && results.query
                  }"</p>
                </div>`;
          },
        },
      }),

      customStats({
        container: document.querySelector('#resultsStats'),
      }),
    ]);

    searchResults.use(
      instantsearch.middlewares.createInsightsMiddleware({
        insightsClient: window.aa,
      })
    );

    searchResults.start();

    queryParameter &&
      searchResults.setUiState({
        Marketing: {
          query: queryParameter,
        },
      });
  }
}

searchResults();
